<?php

/*
 * This file is part of FacturaScripts
 * Copyright (C) 2013-2017  Carlos Garcia Gomez  neorazorx@gmail.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Description of ______________
 *
 * @author ________
 */
namespace FacturaScripts\model;


class conceptoreten extends \fs_model 
{

   public $id;
   public $codigo;
   public $concepto;
   public $porcent;
   public $observa;
   
   public function __construct($p = FALSE)
   {
      parent::__construct('conceptoreten');    // nombre tabla BD
      if($p)
      {
         $this->id = $this->intval($p['id']);
         $this->codigo = $p['codigo'];
         $this->concepto = $p['concepto'];
         $this->porcent = $p['porcent'];
         $this->observa = $p['observa'];
         
      }
      else
      {
         $this->id = NULL;
         $this->codigo = NULL;
         $this->concepto = NULL;
         $this->porcent = 0;
         $this->observa = NULL;
     }
      
   }
   
   protected function install()
   {
      return '';
   }
   
   public function url()
   {
    /*
      if( !is_null($this->idfactura) )
      {
         return "index.php?page=compras_factura&id=".$this->idfactura;
      }
      else if( !is_null($this->idalbaran) )
      {
         return "index.php?page=compras_albaran&id=".$this->idalbaran;
      }
      else if( !is_null($this->idpedido) )
      {
         return "index.php?page=compras_pedido&id=".$this->idpedido;
      }
      //else
      //   return 'index.php?page=informe_retenciones&id='.$this->id;
      */
   }
   
   public function get($id)
   {
      $data = $this->db->select("SELECT * FROM conceptoreten WHERE id = ".$this->var2str($id).";");
      if($data)
      {
         return new conceptoreten($data[0]);
      }
      else
         return FALSE;
   }
   
   public function exists()
   {
      if( is_null($this->id) )
      {
         return FALSE;
      }
      else
         return $this->db->select("SELECT * FROM conceptoreten WHERE id = ".$this->var2str($this->id).";");
   }
   
   public function save()
   {
     $this->nota = $this->no_html($this->nota);
   
   
     
     if ( $this->exists() )
      {
         $sql = "UPDATE conceptoreten SET codigo = ".$this->var2str($this->codigo).", concepto = ".$this->var2str($this->concepto).",
      porcent = ".$this->var2str($this->porcent).", observa = ".$this->var2str($this->observa)."  
                        WHERE id = ".$this->var2str($this->id).";";

                        
         
         return $this->db->exec($sql);
      }
      else
      {
     
         $sql = "INSERT INTO conceptoreten (codigo,concepto,porcent,observa) VALUES
            (".$this->var2str($this->codigo).",".$this->var2str($this->concepto).",".$this->var2str($this->porcent).",
             ".$this->var2str($this->observa).");";

                 
         
         if( $this->db->exec($sql) )
         {
            $this->id = $this->db->lastval();
            return TRUE;
         }
         else
            return FALSE;
      }
   }
   
   public function delete()
   {
      return $this->db->exec("DELETE FROM conceptoreten WHERE id = ".$this->var2str($this->id).";");
   }
   
   public function all_from_factura($id)
   {
      $plist = array();
      
      $data = $this->db->select("SELECT * FROM conceptoreten WHERE codigo = ".$this->var2str($id)." ORDER BY codigo ASC;");
      if($data)
      {
         foreach($data as $d)
            $plist[] = new retencompra($d);
      }
      
      return $plist;
   }
   
   public function all_from_albaran($id)
   {
      $plist = array();
      
      $data = $this->db->select("SELECT * FROM conceptoreten WHERE codigo = ".$this->var2str($id)." ORDER BY codigo ASC;");
      if($data)
      {
         foreach($data as $d)
            $plist[] = new conceptoreten($d);
      }
      
      return $plist;
   }
   
      public function conwhere($valcod)
   {
      $plist = array();
      print_r("data ".$valcod);
      $data = $this->db->select("SELECT * FROM conceptoreten where codigo = '".$valcod."' ORDER BY codigo ASC;");
      print_r("data ".$data);
      if($data)
      {
         foreach($data as $d)
            $plist[] = new retencompra($d);
      }
      
      return $plist;
   }
   
   
   public function all()
   {
      $plist = array();
      
      $data = $this->db->select("SELECT * FROM conceptoreten where porcent > 0 ORDER BY codigo ASC;");
      if($data)
      {
         foreach($data as $d)
            $plist[] = new \conceptoreten($d);

      }
      print_r($plist);
      return $plist;
   }

 }