<?php

/*
* This file is part of FacturaSctipts
* Copyright (C) 2017 Carlos Yánez corp.compunec@gmail.com
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/


if( !function_exists('fs_tipos_id_fiscal') )
{
   /**
    * Devuelve la lista de identificadores fiscales.
    * @return type
    */
   function fs_tipos_id_fiscal()
   {
      return array(FS_CIFNIF, 'Pasaporte', 'RUC', 'CF', 'CedExterior');
  }
  
}
if (!function_exists('fs_documento_new_codigo')) {

    function fs_documento_new_codigo($tipodoc, $codejercicio, $codserie, $numero, $sufijo = '')
    {
        switch (FS_NEW_CODIGO) {
            case 'eneboo':
                $codigo = $codejercicio . str_pad($codserie, 2, '0', STR_PAD_LEFT) . str_pad($numero, 6, '0', STR_PAD_LEFT);
                break;

            case '0-NUM':
                $codigo = str_pad($numero, 13, '0', STR_PAD_LEFT);
                break;

            case 'NUM':
                $codigo = (string) $numero;
                break;

            case 'SERIE-YY-0-NUM':    // control de codigo para multi y luis
                //$codigo = $codserie . substr($codejercicio, -2) . str_pad($numero, 12, '0', STR_PAD_LEFT);
                $codigo = str_pad($numero, 10, '0', STR_PAD_LEFT);      // ORIGINAL DE 12
                break;

            case 'SERIE-YY-0-NUM-CORTO':     
                if (strlen((string) $numero) < 4) {
                    $numero = str_pad($numero, 4, '0', STR_PAD_LEFT);
                }
                
                $codigo = $codserie . substr($codejercicio, -2) . $numero;
                break;

            default:
                /// TIPO + EJERCICIO + SERIE + NÚMERO
                $codigo = strtoupper(substr($tipodoc, 0, 3)) . $codejercicio . $codserie . $numero . $sufijo;
        }

        return $codigo;
    }
  
}