<?php
/**
 * @author Carlos García Gómez      neorazorx@gmail.com
 * @copyright 2015-2018, Carlos García Gómez. All Rights Reserved. 
 */
require_once __DIR__ . '/../lib/tesoreria_controller.php';

/**
 * Description of compras_recibos
 *
 * @author Carlos García Gómez
 */
class compras_recibos extends tesoreria_controller
{

    public $b_url;
    public $check_vencimiento;
    public $codpago;
    public $desde;
    public $estado;
    public $factura;
    private $factura_model;
    public $forma_pago;
    public $hasta;
    public $mostrar;
    public $num_pendientes;
    public $num_resultados;
    public $num_vencidos;
    public $offset;
    public $order;
    public $pagada_previamente;
    public $proveedor;
    public $resultados;
    public $sinasiento;
    public $total_resultados;
    public $total_resultados_txt;
    public $vencimiento;

    public function __construct()
    {
        parent::__construct(__CLASS__, 'Recibos', 'compras');
    }

    protected function private_core()
    {
        parent::private_core();
        $this->factura_model = new factura_proveedor();

        if (isset($_REQUEST['buscar_proveedor'])) {
            $this->fbase_buscar_proveedor($_REQUEST['buscar_proveedor']);
        } else if (isset($_POST['fecha'])) {
            $this->nuevo_recibo();
        } else if (isset($_REQUEST['id'])) {
            /// pestaña recibos de una factura
            $this->ver_recibos_factura();
            $this->share_extenstion();
        } else if (isset($_GET['cronjob'])) {
            $this->template = 'alternative/recibos_cronjob';
            $this->cron_job();
        } else {
            $this->share_extenstion();
            $this->ini_filters();

            $this->num_pendientes = 0;
            $this->num_resultados = 0;
            $this->num_vencidos = 0;
            $this->total_resultados = 0;
            $this->total_resultados_txt = '';

            if (isset($_GET['delete'])) {
                $this->eliminar_recibo($_GET['delete']);
            }

            $this->buscar();
        }
    }

    private function ini_filters()
    {
        $this->proveedor = FALSE;
        if (isset($_REQUEST['codproveedor']) && $_REQUEST['codproveedor'] != '') {
            $pro0 = new proveedor();
            $this->proveedor = $pro0->get($_REQUEST['codproveedor']);
        }

        $this->mostrar = isset($_GET['mostrar']) ? $_GET['mostrar'] : 'buscar';
        $this->estado = isset($_REQUEST['estado']) ? $_REQUEST['estado'] : '';
        $this->sinasiento = isset($_REQUEST['sinasiento']);
        $this->codpago = isset($_REQUEST['codpago']) ? $_REQUEST['codpago'] : '';
        $this->desde = isset($_REQUEST['desde']) ? $_REQUEST['desde'] : '';
        $this->hasta = isset($_REQUEST['hasta']) ? $_REQUEST['hasta'] : '';
        $this->check_vencimiento = isset($_REQUEST['vencimiento']);
        $this->offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;

        $this->order = 'fecha DESC';
        if (isset($_GET['order'])) {
            $orden_l = $this->orden_recibos();
            if (isset($orden_l[$_GET['order']])) {
                $this->order = $orden_l[$_GET['order']]['orden'];
            }

            setcookie('compras_recibos_order', $this->order, time() + FS_COOKIES_EXPIRE);
        } else if (isset($_COOKIE['compras_recibos_order'])) {
            $this->order = $_COOKIE['compras_recibos_order'];
        }

        $this->b_url = $this->url() . "&mostrar=" . $this->mostrar
            . "&desde=" . $this->desde
            . "&hasta=" . $this->hasta
            . "&estado=" . $this->estado
            . "&codpago=" . $this->codpago;

        if ($this->proveedor) {
            $this->b_url .= '&codproveedor=' . $this->proveedor->codproveedor;
        }

        if ($this->check_vencimiento) {
            $this->b_url .= '&vencimiento=TRUE';
        }

        if ($this->sinasiento) {
            $this->b_url .= '&sinasiento=TRUE';
        }
    }

    private function ver_recibos_factura()
    {
        $this->template = 'tab/tab_factura_proveedor';

        $this->factura = $this->factura_model->get($_REQUEST['id']);
        if ($this->factura) {
            $this->resultados = $this->recibo_proveedor_model->all_from_factura($_REQUEST['id']);

            if (isset($_GET['regenerar'])) {
                foreach ($this->resultados as $res) {
                    $res->delete();
                }

                $this->factura->pagada = FALSE;
                $this->factura->save();
                $this->sync_factura(TRUE);

                $this->new_message('Recibos regenerados.');
            }

            $this->pagada_previamente = FALSE;
            if ($this->factura->pagada && count($this->resultados) == 0) {
                $this->pagada_previamente = TRUE;
            } else {
                $this->sync_factura(TRUE);
            }

            $this->vencimiento = Date('d-m-Y', strtotime('+1month'));
        }
    }

    private function buscar()
    {
        $this->resultados = [];

        /// añadimos segundo nivel de ordenación
        $order2 = '';
        if ($this->order == 'fecha DESC' || $this->order == 'fechav DESC') {
            $order2 = ', codigo DESC';
        } else if ($this->order == 'fecha ASC' || $this->order == 'fechav ASC') {
            $order2 = ', codigo ASC';
        }

        $sql = 'FROM recibosprov WHERE 1=1';
        if ($this->mostrar == 'pendientes') {
            $sql .= " AND estado = 'Emitido' AND " . "fechav >= " . $this->empresa->var2str(date('d-m-Y'));
        } else if ($this->mostrar == 'vencidos') {
            $sql .= " AND estado = 'Devuelto' OR estado = 'Vencido'";
        } else {
            if ($this->query != '') {
                $query = $this->empresa->no_html(mb_strtolower($this->query, 'UTF8'));
                if (is_numeric($query)) {
                    $sql .= " AND (codigo LIKE '%" . $query . "%' OR observaciones LIKE '%" . $query . "%')";
                } else {
                    $sql .= " AND (lower(codigo) LIKE '%" . $query . "%' OR lower(observaciones) LIKE '%" . str_replace(' ', '%', $query) . "%')";
                }
            }

            if ($this->proveedor) {
                $sql .= " AND codproveedor = " . $this->empresa->var2str($this->proveedor->codproveedor);
            }

            if ($this->estado) {
                $sql .= " AND estado = " . $this->empresa->var2str($this->estado);
            }

            if ($this->codpago) {
                $sql .= " AND codpago = " . $this->empresa->var2str($this->codpago);
            }

            if ($this->desde != '') {
                if ($this->check_vencimiento) {
                    $sql .= " AND fechav >= " . $this->empresa->var2str($this->desde);
                } else {
                    $sql .= " AND fecha >= " . $this->empresa->var2str($this->desde);
                }
            }

            if ($this->hasta != '') {
                if ($this->check_vencimiento) {
                    $sql .= " AND fechav <= " . $this->empresa->var2str($this->hasta);
                } else {
                    $sql .= " AND fecha <= " . $this->empresa->var2str($this->hasta);
                }
            }

            if ($this->sinasiento) {
                $sql .= " AND idrecibo IN (SELECT idrecibo FROM pagosdevolprov WHERE idasiento IS NULL)";
            }
        }

        $data = $this->db->select('SELECT COUNT(idrecibo) as num ' . $sql);
        if ($data) {
            $this->num_resultados = intval($data[0]['num']);

            $data2 = $this->db->select_limit('SELECT * ' . $sql . ' ORDER BY ' . $this->order . $order2, FS_ITEM_LIMIT, $this->offset);
            if ($data2) {
                foreach ($data2 as $d) {
                    $this->resultados[] = new recibo_proveedor($d);
                }
            }

            $data3 = $this->db->select("SELECT SUM(importeeuros) as total " . $sql);
            if ($data3) {
                $this->total_resultados = $this->euro_convert(floatval($data3[0]['total']));
                $this->total_resultados_txt = 'Suma total de los resultados:';
            }
        }

        $this->num_pendientes = $this->get_num_pendientes('recibosprov');
        $this->num_vencidos = $this->get_num_vencidos('recibosprov');
    }

    public function paginas()
    {
        if ($this->mostrar == 'pendientes') {
            $total = $this->num_pendientes;
        } else if ($this->mostrar == 'vencidos') {
            $total = $this->num_vencidos;
        } else {
            $total = $this->num_resultados;
        }

        return $this->fbase_paginas($this->b_url, $total, $this->offset);
    }

    private function share_extenstion()
    {
        /// metemos la pestaña de recibos en la página de factura de compra
        $fsext0 = new fs_extension();
        $fsext0->name = 'recibos_factura';
        $fsext0->from = __CLASS__;
        $fsext0->to = 'compras_factura';
        $fsext0->type = 'tab';
        $fsext0->text = '<span class="glyphicon glyphicon-piggy-bank" aria-hidden="true"></span>'
            . '<span class="hidden-xs">&nbsp; Recibos</span>';
        $fsext0->save();

        /// metemos la pestaña de recibos en la página de editar factura de compra
        $fsext1 = new fs_extension();
        $fsext1->name = 'recibos_factura_editar';
        $fsext1->from = __CLASS__;
        $fsext1->to = 'editar_factura_prov';
        $fsext1->type = 'tab';
        $fsext1->text = '<span class="glyphicon glyphicon-piggy-bank" aria-hidden="true"></span>'
            . '<span class="hidden-xs">&nbsp; Recibos</span>';
        $fsext1->save();

        /// desactivamos el botón de pagada/sin pagar de la factura
        $fsext2 = new fs_extension();
        $fsext2->name = 'no_button_pagada';
        $fsext2->from = __CLASS__;
        $fsext2->to = 'compras_factura';
        $fsext2->type = 'config';
        $fsext2->text = 'no_button_pagada';
        $fsext2->save();

        /// metemos el botón recibos en la página del proveedor
        $fsext3 = new fs_extension();
        $fsext3->name = 'recibos_proveedor';
        $fsext3->from = __CLASS__;
        $fsext3->to = 'compras_proveedor';
        $fsext3->type = 'button';
        $fsext3->text = '<span class="glyphicon glyphicon-piggy-bank" aria-hidden="true"></span> &nbsp; Recibos';
        $fsext3->save();

        /// metemos el botón recibos en el listado de facturas
        $fsext4 = new fs_extension();
        $fsext4->name = 'recibos_facturas';
        $fsext4->from = __CLASS__;
        $fsext4->to = 'compras_facturas';
        $fsext4->type = 'button';
        $fsext4->text = '<span class="glyphicon glyphicon-piggy-bank" aria-hidden="true"></span>'
            . '<span class="hidden-xs hidden-sm">&nbsp; Recibos</span>';
        $fsext4->save();

        /// metemos el iframe en facturas
        $fsext5 = new fs_extension();
        $fsext5->name = 'if_recibos_facturas';
        $fsext5->from = __CLASS__;
        $fsext5->to = 'compras_facturas';
        $fsext5->type = 'hidden_iframe';
        $fsext5->params = '&cronjob=TRUE';
        $fsext5->save();
    }

    private function nuevo_recibo()
    {
        $this->factura = $this->factura_model->get($_POST['idfactura']);
        if ($this->factura) {
            $recibo = new recibo_proveedor();
            $recibo->cifnif = $this->factura->cifnif;
            $recibo->coddivisa = $this->factura->coddivisa;
            $recibo->tasaconv = $this->factura->tasaconv;
            $recibo->codpago = $this->factura->codpago;
            $recibo->codproveedor = $this->factura->codproveedor;
            $recibo->codserie = $this->factura->codserie;
            $recibo->estado = 'Emitido';
            $recibo->fecha = $_POST['fecha'];
            $recibo->fechav = $_POST['fechav'];
            $recibo->idfactura = $this->factura->idfactura;
            $recibo->importe = floatval($_POST['importe']);
            $recibo->nombreproveedor = $this->factura->nombre;
            $recibo->numero = $recibo->new_numero($recibo->idfactura);
            $recibo->codigo = $this->factura->codigo . '-' . sprintf('%02s', $recibo->numero);

            $cbp = new cuenta_banco_proveedor();
            foreach ($cbp->all_from_proveedor($recibo->codproveedor) as $cuenta) {
                if (is_null($recibo->codcuenta) OR $cuenta->principal) {
                    $recibo->codcuenta = $cuenta->codcuenta;
                    $recibo->iban = $cuenta->iban;
                    $recibo->swift = $cuenta->swift;
                }
            }

            if ($recibo->save()) {
                $this->new_message('Recibo creado correctamente.');
                header('Location: ' . $recibo->url());
            } else {
                $this->new_error_msg('Error al guardar el recibo.');
            }
        } else {
            $this->new_error_msg('Factura no encontrada.');
        }
    }

    private function eliminar_recibo($id)
    {
        $recibo2 = $this->recibo_proveedor_model->get($id);
        if ($recibo2) {
            if ($recibo2->delete()) {
                $this->new_message('Recibo eliminado correctamente.');
            } else {
                $this->new_message('Error al eliminar el recibo.');
            }
        } else {
            $this->new_message('Recibo no encontrado.');
        }
    }

    private function sync_factura($actualizar = FALSE)
    {
        if ($actualizar) {
            $this->resultados = $this->recibo_factura_tools->sync_factura_prov($this->factura);
        } else {
            $this->recibo_factura_tools->sync_factura_prov($this->factura);
        }

        $this->recibo_factura_tools->errors = [];
    }

    private function cron_job()
    {
        /// comprobamos los recibos
        $this->recibo_proveedor_model->cron_job();

        /// comprobamos los pagos
        $pago_prov = new pago_recibo_proveedor();
        $pago_prov->cron_job();

        $sql = "SELECT * FROM facturasprov WHERE pagada = false";
        if (mt_rand(0, 2) > 0) {
            $sql .= " AND NOT EXISTS (SELECT idrecibo FROM recibosprov WHERE idfactura = facturasprov.idfactura)";
        }

        if (strtolower(FS_DB_TYPE) == 'mysql') {
            $sql .= " ORDER BY RAND()";
        } else {
            $sql .= " ORDER BY random()";
        }

        $data = $this->db->select_limit($sql, FS_ITEM_LIMIT, 0);
        if ($data) {
            foreach ($data as $d) {
                $this->factura = new factura_proveedor($d);

                $this->resultados = $this->recibo_proveedor_model->all_from_factura($this->factura->idfactura);
                $this->sync_factura();

                $this->new_advice('Factura ' . $this->factura->codigo . " sincronizada");
            }
        }
    }
}
