<?php
/**
 * @author Carlos García Gómez      neorazorx@gmail.com
 * @copyright 2015-2018, Carlos García Gómez. All Rights Reserved. 
 */
require_once __DIR__ . '/../lib/tesoreria_controller.php';

/**
 * Description of contabilidad_plazos_pago
 *
 * @author Carlos García Gómez
 */
class contabilidad_plazos_pago extends tesoreria_controller
{

    public $forma_pago_s;
    public $forma_pago_plazo_model;
    public $pendiente;
    public $plazos;

    public function __construct()
    {
        parent::__construct(__CLASS__, 'Plazos de pago', 'contabilidad', FALSE, FALSE);
    }

    protected function private_core()
    {
        parent::private_core();
        $this->share_extensions();
        $this->forma_pago_plazo_model = new forma_pago_plazo();
        $this->forma_pago_s = isset($_REQUEST['cod']) ? $this->forma_pago->get($_REQUEST['cod']) : false;
        if ($this->forma_pago_s) {
            if (isset($_POST['id'])) {
                $this->editar_plazo();
            } else if (isset($_GET['nueva'])) {
                $this->nuevo_plazo_predeterminado();
            } else if (isset($_POST['dias'])) {
                $this->nuevo_plazo($_POST['dias'], $_POST['meses'], $_POST['aplazado']);
            } else if (isset($_GET['delete'])) {
                $this->eliminar_plazo($_GET['delete']);
            }

            $this->plazos = $this->forma_pago_plazo_model->all_from($this->forma_pago_s->codpago);
            $this->comprobar_plazos();
        } else {
            $this->new_error_msg('Forma de pago no encontrada.', 'error', FALSE, FALSE);
        }
    }

    private function share_extensions()
    {
        $fsext = new fs_extension();
        $fsext->name = 'btn_formas_pago';
        $fsext->from = __CLASS__;
        $fsext->to = 'contabilidad_formas_pago';
        $fsext->type = 'config';
        $fsext->text = 'button_plazos';
        $fsext->save();
    }

    public function url()
    {
        if ($this->forma_pago_s) {
            return 'index.php?page=' . __CLASS__ . '&cod=' . $this->forma_pago_s->codpago;
        }

        return parent::url();
    }

    private function vencimiento2dias($cod)
    {
        $vencimientos = array(
            '+0day' => 0,
            '+1day' => 1,
            '+1week' => 7,
            '+2week' => 14,
            '+3week' => 21,
            '+1month' => 30,
            '+2month' => 60,
            '+3month' => 90,
            '+4month' => 120,
            '+5month' => 150,
            '+6month' => 180,
            '+7month' => 210,
            '+8month' => 240,
            '+9month' => 270,
            '+10month' => 300,
            '+11month' => 330,
            '+12month' => 365,
        );

        if (isset($vencimientos[$cod])) {
            return $vencimientos[$cod];
        }

        return 30;
    }

    private function nuevo_plazo_predeterminado()
    {
        $dias = $this->vencimiento2dias($this->forma_pago_s->vencimiento);
        $this->nuevo_plazo($dias, 0, 100);
    }

    private function nuevo_plazo($dias, $meses, $aplazado)
    {
        $plazo = new forma_pago_plazo();
        $plazo->codpago = $this->forma_pago_s->codpago;
        $plazo->dias = intval($dias);
        $plazo->meses = intval($meses);
        $plazo->aplazado = floatval(str_replace(',', '.', $aplazado));

        if ($plazo->save()) {
            $this->new_message('Datos guardados correctamente.');
        } else {
            $this->new_error_msg('Error al modificar el plazo.');
        }
    }

    private function editar_plazo()
    {
        $plazo = $this->forma_pago_plazo_model->get($_POST['id']);
        if ($plazo) {
            $plazo->dias = intval($_POST['dias']);
            $plazo->meses = intval($_POST['meses']);
            $plazo->aplazado = floatval(str_replace(',', '.', $_POST['aplazado']));

            if ($plazo->save()) {
                $this->new_message('Datos modificados correctamente.');
            } else {
                $this->new_error_msg('Error al modificar el plazo.');
            }
        } else {
            $this->new_error_msg('Plazo no encontrado.');
        }
    }

    private function eliminar_plazo($id)
    {
        $plazo = $this->forma_pago_plazo_model->get($id);
        if ($plazo) {
            if ($plazo->delete()) {
                $this->new_message('Plazo eliminado correctamente.');
            } else {
                $this->new_error_msg('Error al eliminar el plazo.');
            }
        } else {
            $this->new_error_msg('Plazo no encontrado.');
        }
    }

    private function comprobar_plazos()
    {
        $this->pendiente = 100;
        if ($this->plazos) {
            foreach ($this->plazos as $pl) {
                $this->pendiente -= $pl->aplazado;
            }

            $this->pendiente = round($this->pendiente, 2);
            if ($this->pendiente > 0) {
                $this->new_message('Falta un ' . $this->pendiente . '% por asignar.');
            } else if ($this->pendiente < 0) {
                $this->new_message('Sobra un ' . abs($this->pendiente) . '% asignado.');
            } else {
                $this->forma_pago_s->vencimiento = '+0day';

                /// nos guardamos el último plazo para ponerlo como vencimiento de la forma de pago
                foreach ($this->plazos as $pl) {
                    if ($pl->dias > 0) {
                        $months = $pl->dias / 30;
                        if (is_int($months)) {
                            $this->forma_pago_s->vencimiento = '+' . $months . 'months';
                        } else {
                            $this->forma_pago_s->vencimiento = '+' . $pl->dias . 'days';
                        }
                    }
                }

                $this->forma_pago_s->save();
            }
        }
    }
}
