<?php
/**
 * @author Carlos García Gómez      neorazorx@gmail.com
 * @copyright 2015-2018, Carlos García Gómez. All Rights Reserved. 
 */
require_once 'plugins/facturacion_base/extras/fbase_controller.php';

/**
 * Description of contabilidad_subcuentas
 *
 * @author Carlos García Gómez
 */
class contabilidad_subcuentas extends fbase_controller
{

    public $codejercicio;
    public $ejercicio;
    public $offset;
    public $order;
    public $resultados;
    public $total;

    public function __construct()
    {
        parent::__construct(__CLASS__, 'Subcuentas', 'contabilidad');
    }

    protected function private_core()
    {
        $this->codejercicio = '';
        $this->ejercicio = new ejercicio();
        $this->offset = 0;
        $this->order = 'codejercicio DESC, codsubcuenta ASC';
        $this->resultados = [];
        $this->total = 0;

        $this->get_filters();
        $this->buscar();
    }

    private function get_filters()
    {
        if (isset($_REQUEST['codejercicio'])) {
            $this->codejercicio = $_REQUEST['codejercicio'];
        }

        if (isset($_REQUEST['offset'])) {
            $this->offset = $_REQUEST['offset'];
        }

        if (isset($_REQUEST['order'])) {
            $this->order = $_REQUEST['order'];
        }
    }

    public function buscar()
    {
        $sql = "FROM co_subcuentas WHERE 1 = 1";

        if ($this->query) {
            if (is_numeric($this->query)) {
                $sql .= " AND codsubcuenta LIKE '%" . $this->query . "%'";
            } else {
                $sql .= " AND lower(descripcion) LIKE '%" . $this->empresa->no_html($this->query) . "%'";
            }
        }

        if ($this->codejercicio !== '') {
            $sql .= " AND codejercicio = " . $this->empresa->var2str($this->codejercicio);
        }

        $data = $this->db->select("SELECT COUNT(1) as num " . $sql);
        if ($data) {
            $this->total = (int) $data[0]['num'];

            $data2 = $this->db->select_limit("SELECT * " . $sql . " ORDER BY " . $this->order, FS_ITEM_LIMIT, $this->offset);
            if ($data2) {
                foreach ($data2 as $d) {
                    $this->resultados[] = new subcuenta($d);
                }
            }
        }
    }

    public function orden()
    {
        return array(
            'codigo_desc' => array(
                'texto' => 'Código descendente',
                'orden' => 'codejercicio DESC, codsubcuenta DESC'
            ),
            'codigo_asc' => array(
                'texto' => 'Código ascendente',
                'orden' => 'codejercicio DESC, codsubcuenta ASC'
            ),
            'saldo_desc' => array(
                'texto' => 'Saldo descendente',
                'orden' => 'saldo DESC'
            ),
            'saldo_asc' => array(
                'texto' => 'Saldo ascendente',
                'orden' => 'saldo ASC'
            )
        );
    }

    public function paginas()
    {
        $url = $this->url() . "&query=" . $this->query
            . "&codejercicio=" . $this->codejercicio
            . "&order=" . $this->order;

        return $this->fbase_paginas($url, $this->total, $this->offset);
    }
}
