<?php
/**
 * @author Carlos García Gómez      neorazorx@gmail.com
 * @copyright 2014-2018, Carlos García Gómez. All Rights Reserved. 
 */
require_once __DIR__ . '/../lib/tesoreria_controller.php';

/**
 * Description of pagar_facturas
 *
 * @author Carlos García Gómez
 */
class pagar_facturas extends tesoreria_controller
{

    public $cliente;
    public $codcliente;
    public $codserie;
    public $codsubcuenta_pago;
    public $desde;
    private $factura_model;
    public $fecha_pago;
    public $hasta;
    public $observaciones;
    public $resultados;
    public $serie;

    public function __construct()
    {
        parent::__construct(__CLASS__, 'Pagar facturas', 'ventas', FALSE, FALSE);
    }

    protected function private_core()
    {
        parent::private_core();
        $this->cuenta_banco = new cuenta_banco();
        $this->factura_model = new factura_cliente();
        $this->serie = new serie();
        $this->ini_filters();

        if (isset($_REQUEST['buscar_cliente'])) {
            $this->fbase_buscar_cliente($_REQUEST['buscar_cliente']);
        } else if (isset($_POST['idfactura'])) {
            if ($this->codcliente) {
                $this->pagar_facturas_cliente();
            } else {
                $this->pagar_facturas();
            }
        } else {
            $this->share_extensions();
        }

        $this->resultados = $this->buscar_facturas();
    }

    private function ini_filters()
    {
        $this->desde = isset($_REQUEST['desde']) ? $_REQUEST['desde'] : Date('01-01-Y');
        $this->hasta = isset($_REQUEST['hasta']) ? $_REQUEST['hasta'] : Date('t-m-Y');

        $this->cliente = FALSE;
        $this->codcliente = FALSE;
        if (isset($_REQUEST['codcliente']) AND ! isset($_POST['todos'])) {
            $this->codcliente = $_REQUEST['codcliente'];

            $cli0 = new cliente();
            $this->cliente = $cli0->get($this->codcliente);
        }

        $this->codserie = isset($_REQUEST['codserie']) ? $_REQUEST['codserie'] : $this->empresa->codserie;
        $this->codsubcuenta_pago = isset($_POST['codsubcuenta']) ? $_POST['codsubcuenta'] : FALSE;
        $this->fecha_pago = isset($_POST['fecha']) ? $_POST['fecha'] : $this->today();
        $this->observaciones = isset($_POST['observaciones']) ? $_POST['observaciones'] : '';
    }

    private function share_extensions()
    {
        $fsext = new fs_extension();
        $fsext->name = 'pagar_facturas';
        $fsext->from = __CLASS__;
        $fsext->to = 'ventas_facturas';
        $fsext->type = 'button';
        $fsext->text = '<span class="glyphicon glyphicon-check" aria-hidden="true"></span>'
            . '<span class="hidden-xs">&nbsp; Pagar...</span>';
        $fsext->save();

        $fsext2 = new fs_extension();
        $fsext2->name = 'pagar_recibos';
        $fsext2->from = __CLASS__;
        $fsext2->to = 'ventas_recibos';
        $fsext2->type = 'button';
        $fsext2->text = '<span class="glyphicon glyphicon-check" aria-hidden="true"></span>'
            . '<span class="hidden-xs">&nbsp; Pagar...</span>';
        $fsext2->save();
    }

    private function buscar_facturas()
    {
        $facturas = [];
        $sql = "SELECT * FROM facturascli WHERE pagada = false"
            . " AND fecha >= " . $this->serie->var2str($this->desde)
            . " AND fecha <= " . $this->serie->var2str($this->hasta)
            . " AND codserie = " . $this->serie->var2str($this->codserie);

        if ($this->codcliente) {
            $sql .= " AND codcliente = " . $this->serie->var2str($this->codcliente);
        }

        if ($this->observaciones !== '') {
            $observaciones = mb_strtolower($this->empresa->no_html($this->observaciones), 'UTF8');
            $sql .= " AND lower(observaciones) LIKE '%" . str_replace(' ', '%', $observaciones) . "%'";
        }

        $sql .= " ORDER BY fecha ASC, codigo ASC";
        $data = $this->db->select_limit($sql, FS_ITEM_LIMIT, 0);
        if ($data) {
            foreach ($data as $d) {
                $facturas[] = new factura_cliente($d);
            }
        }

        return $facturas;
    }

    private function pagar_facturas()
    {
        $num = 0;
        foreach ($_POST['idfactura'] as $id) {
            $error = FALSE;
            foreach ($this->recibo_cliente_model->all_from_factura($id) as $recibo) {
                if ($recibo->estado != 'Pagado' && !$this->recibo_factura_tools->nuevo_pago_cli($recibo, $this->codsubcuenta_pago, 'Pago', $this->fecha_pago)) {
                    $error = TRUE;
                    break;
                }
            }

            /// mostramos los errores al generar los asientos
            if (!empty($this->recibo_factura_tools->errors)) {
                $error = TRUE;
            }

            if ($error) {
                break;
            }

            $this->marcar_factura_pagada($num, $id);
        }

        $this->new_message($num . ' facturas marcadas como pagadas, estas son las siguientes.');
    }

    private function pagar_facturas_cliente()
    {
        $error = FALSE;
        $num = 0;

        /// ¿Generamos el asiento de pago?
        $asientop = NULL;
        if ($this->empresa->contintegrada && $this->codsubcuenta_pago !== '---NO---') {
            /// ¿Cuanto es el total?
            $coddivisa = NULL;
            $importe = 0;
            $tasaconv = 1;
            foreach ($_POST['idfactura'] as $id) {
                $recibos = $this->recibo_cliente_model->all_from_factura($id);
                foreach ($recibos as $recibo) {
                    if ($recibo->estado != 'Pagado') {
                        if (is_null($coddivisa) || $recibo->coddivisa == $coddivisa) {
                            $coddivisa = $recibo->coddivisa;
                            $importe += $recibo->importe;
                            $tasaconv = $recibo->tasaconv;
                        } else {
                            $this->new_error_msg('Todos los recibos a pagar deben ser de la misma divisa.');
                            $error = TRUE;
                            break;
                        }
                    }
                }
            }

            if (!$error) {
                $asientop = $this->recibo_factura_tools->nuevo_asiento_pago_cli(
                    $importe, $coddivisa, $tasaconv, 'Cobro de facturas de ' . $this->cliente->nombre, $this->cliente, $this->codsubcuenta_pago, FALSE, $this->fecha_pago
                );
                if ($asientop) {
                    $this->new_message('<a href="' . $asientop->url() . '">Asiento de pago</a> generado.');

                    /// ponemos algo en el tipo, para que no lo tengan en cuenta los informes
                    $asientop->tipodocumento = 'Facturas de cliente';
                    $asientop->documento = $this->cliente->codcliente;
                    $asientop->save();
                } else {
                    $this->new_error_msg('Error al generar el asiento.');
                    $error = TRUE;
                }
            }
        }

        if (!$error) {
            foreach ($_POST['idfactura'] as $id) {
                $recibos = $this->recibo_cliente_model->all_from_factura($id);
                foreach ($recibos as $recibo) {
                    if ($recibo->estado != 'Pagado') {
                        $pago = new pago_recibo_cliente();
                        $pago->idrecibo = $recibo->idrecibo;
                        $pago->fecha = $this->fecha_pago;

                        if ($asientop) {
                            $pago->idasiento = $asientop->idasiento;

                            /// nos guardamos la subcuenta
                            foreach ($asientop->get_partidas() as $lin) {
                                /**
                                 * Por si acaso no se ha seleccionado una subcuenta de pago,
                                 * nos guardamos alguna.
                                 */
                                $pago->codsubcuenta = $lin->codsubcuenta;
                                $pago->idsubcuenta = $lin->idsubcuenta;

                                if ($lin->codsubcuenta == $this->codsubcuenta_pago) {
                                    /// salimos del bucle, ya no se asigna ninguna otra subcuenta
                                    break;
                                }
                            }
                        }

                        if ($pago->save()) {
                            $recibo->estado = 'Pagado';
                            $recibo->fechap = $this->fecha_pago;

                            if (!$recibo->save()) {
                                $error = TRUE;
                                break;
                            }
                        }
                    }
                }

                if ($error) {
                    break;
                }

                $this->marcar_factura_pagada($num, $id);
            }
        }

        $this->new_message($num . ' facturas marcadas como pagadas, estas son las siguientes.');
    }

    private function marcar_factura_pagada(&$num, $id)
    {
        $factura = $this->factura_model->get($id);
        if ($factura) {
            $factura->pagada = TRUE;
            if ($factura->save()) {
                $num++;
            }
        }
    }
}
