<?php
/*
 * @author Carlos García Gómez      neorazorx@gmail.com
 * @copyright 2015-2018, Carlos García Gómez. All Rights Reserved. 
 */

require_once __DIR__ . '/../lib/tesoreria_controller.php';

/**
 * Description of informe_pago
 *
 * @author Carlos García Gómez
 */
class tab_pagos extends tesoreria_controller
{

    public $bloquear;
    public $coddivisa;
    public $pagado;
    public $pago;
    public $pagos;
    public $pendiente;

    public function __construct()
    {
        parent::__construct(__CLASS__, 'pago', 'ventas', FALSE, FALSE);
    }

    protected function private_core()
    {
        parent::private_core();
        $this->template = 'tab/tab_pagos';
        $this->coddivisa = $this->empresa->coddivisa;
        $this->pagado = FALSE;
        $this->pagos = [];
        $this->pendiente = 0;
        $this->pago = new pago();
        $this->pago->cron_job();

        if (isset($_GET['delete'])) {
            $this->eliminar_pago($_GET['delete']);
        } else if (isset($_POST['idpago'])) {
            $this->editar_pago();
        } else if (isset($_POST['importe'])) {
            $this->nuevo_pago();
        }

        $this->bloquear = TRUE;
        if (isset($_REQUEST['albaran'])) {
            $this->cargar_albaran();
        } else if (isset($_REQUEST['pedido'])) {
            $this->cargar_pedido();
        }

        $this->share_extensions();
    }

    public function url()
    {
        if (isset($_REQUEST['albaran'])) {
            return 'index.php?page=' . __CLASS__ . '&albaran=TRUE&id=' . $_REQUEST['id'];
        } else if (isset($_REQUEST['pedido'])) {
            return 'index.php?page=' . __CLASS__ . '&pedido=TRUE&id=' . $_REQUEST['id'];
        }

        return parent::url();
    }

    private function share_extensions()
    {
        $extensiones = array(
            array(
                'name' => 'pago_albaran',
                'page_from' => __CLASS__,
                'page_to' => 'ventas_albaran',
                'type' => 'tab',
                'text' => '<span class="glyphicon glyphicon-piggy-bank" aria-hidden="true"></span><span class="hidden-xs">&nbsp; Pagos</span>',
                'params' => '&albaran=TRUE'
            ),
            array(
                'name' => 'pago_pedido',
                'page_from' => __CLASS__,
                'page_to' => 'ventas_pedido',
                'type' => 'tab',
                'text' => '<span class="glyphicon glyphicon-piggy-bank" aria-hidden="true"></span><span class="hidden-xs">&nbsp; Pagos</span>',
                'params' => '&pedido=TRUE'
            )
        );
        foreach ($extensiones as $ext) {
            $fsext = new fs_extension($ext);
            if (!$fsext->save()) {
                $this->new_error_msg('Imposible guardar los datos de la extensión ' . $ext['name'] . '.');
            }
        }
    }

    private function nuevo_pago()
    {
        if (isset($_REQUEST['albaran'])) {
            $this->pago->fase = ucfirst(FS_ALBARAN);
            $this->pago->idalbaran = $_REQUEST['id'];
        } else if (isset($_REQUEST['pedido'])) {
            $this->pago->fase = ucfirst(FS_PEDIDO);
            $this->pago->idpedido = $_REQUEST['id'];
        }

        $this->pago->fecha = $_POST['fecha'];
        $this->pago->importe = floatval($_POST['importe']);
        $this->pago->nota = $_POST['nota'];

        if ($this->pago->save()) {
            $this->new_message('Pago guardado correctamente.');
        } else {
            $this->new_error_msg('Error al guardar el pago.');
        }
    }

    private function editar_pago()
    {
        $pago = $this->pago->get($_POST['idpago']);
        if ($pago) {
            $pago->fecha = $_POST['fecha'];
            $pago->importe = floatval($_POST['importe']);
            $pago->nota = $_POST['nota'];

            if ($pago->save()) {
                $this->new_message('Pago modificado correctamente.');
            } else {
                $this->new_error_msg('Error al modificar el pago.');
            }
        } else {
            $this->new_error_msg('Pago no encontrado.');
        }
    }

    private function eliminar_pago($id)
    {
        $pago = $this->pago->get($id);
        if ($pago) {
            if ($pago->delete()) {
                $this->new_message('Pago eliminado correctamente.');
            } else {
                $this->new_error_msg('Error al eliminar el pago.');
            }
        } else {
            $this->new_error_msg('Pago no encontrado.');
        }
    }

    private function cargar_albaran()
    {
        $alb0 = new albaran_cliente();
        $albaran = $alb0->get($_REQUEST['id']);
        if ($albaran) {
            /// buscamos pagos de la fase pedido
            /// un albarán puede ser una agrupación de muchos pedidos
            $idpedido = NULL;
            foreach ($albaran->get_lineas() as $linea) {
                /// el idpedido lo tienes en las lineas del albarán
                if ($linea->idpedido != $idpedido) {
                    $idpedido = $linea->idpedido;
                    $this->db->exec("UPDATE pagos SET idalbaran = " . $alb0->var2str($_REQUEST['id']) . " WHERE idpedido = " . $alb0->var2str($idpedido) . ";");
                }
            }

            /// fase de albarán
            $this->pagos = $this->pago->all_from_albaran($_REQUEST['id']);
            if ($this->pagos AND $albaran->idfactura) {
                $fac0 = new factura_cliente();
                $factura = $fac0->get($albaran->idfactura);
                if ($factura) {
                    $this->recibo_factura_tools->sync_factura_cli($factura);
                }
            }

            $this->pendiente = $albaran->total;
            foreach ($this->pagos as $i => $value) {
                $this->pendiente -= $value->importe;
                $this->pagos[$i]->pendiente = $this->pendiente;
            }

            if (abs($this->pendiente) < 0.1) {
                $this->pagado = TRUE;
            }

            if ($albaran->ptefactura) {
                $this->bloquear = FALSE;
            }
        }
    }

    private function cargar_pedido()
    {
        /// fose de pedido
        $this->pagos = $this->pago->all_from_pedido($_REQUEST['id']);

        $ped0 = new pedido_cliente();
        $pedido = $ped0->get($_REQUEST['id']);
        if ($pedido) {
            $this->pendiente = $pedido->total;
            foreach ($this->pagos as $i => $value) {
                $this->pendiente -= $value->importe;
                $this->pagos[$i]->pendiente = $this->pendiente;
            }

            if (abs($this->pendiente) < 0.1) {
                $this->pagado = TRUE;
            }

            if ($pedido->status == 0) {
                $this->bloquear = FALSE;
            }
        }
    }
}
