<?php
/**
 * @author Carlos García Gómez      neorazorx@gmail.com
 * @copyright 2015-2018, Carlos García Gómez. All Rights Reserved. 
 */
require_once __DIR__ . '/../lib/tesoreria_controller.php';

/**
 * Description of ventas_recibo
 *
 * @author Carlos García Gómez
 */
class ventas_recibo extends tesoreria_controller
{

    public $anticipo;
    public $cliente;
    public $cuenta_banco;
    public $ejercicio;
    public $factura;
    private $pago_model;
    public $pagos;
    public $recibo;
    public $recibos;
    public $subcuenta_cli;
    public $subcuentas_pago;

    public function __construct()
    {
        parent::__construct(__CLASS__, 'Recibo', 'ventas', FALSE, FALSE);
    }

    protected function private_core()
    {
        parent::private_core();
        $this->cuenta_banco = new cuenta_banco();
        $this->pago_model = new pago_recibo_cliente();
        $this->recibo = isset($_REQUEST['id']) ? $this->recibo_cliente_model->get($_REQUEST['id']) : false;
        if ($this->recibo) {
            $this->page->title = 'Recibo ' . $this->recibo->codigo;

            /// cargamos la factura y las subcuentas
            $fact = new factura_cliente();
            $this->factura = $fact->get($this->recibo->idfactura);
            $this->get_subcuentas();

            if (isset($_POST['fechav'])) {
                $this->editar_recibo();
            } else if (isset($_POST['nuevopago'])) {
                $this->nuevo_pago();
            } else if (isset($_GET['deletep'])) {
                $this->eliminar_pago($_GET['deletep']);
            } else if (isset($_GET['sacar_remesa'])) {
                $this->sacar_de_remesa();
            }

            $this->pagos = $this->pago_model->all_from_recibo($this->recibo->idrecibo);
            $this->recibos = $this->recibo->all_from_factura($this->recibo->idfactura);
            $this->recibo_factura_tools->sync_factura_cli($this->factura);
        } else {
            $this->new_error_msg('Recibo no encontrado.', 'error', FALSE, FALSE);
        }
    }

    private function editar_recibo()
    {
        $this->recibo->importe = floatval($_POST['importe']);
        $this->recibo->tasaconv = floatval($_POST['tasaconv']);
        $this->recibo->fecha = $_POST['emitido'];
        $this->recibo->fechav = $_POST['fechav'];
        $this->recibo->iban = $_POST['iban'];
        $this->recibo->swift = $_POST['swift'];
        $this->recibo->observaciones = $_POST['observaciones'];

        if (isset($_POST['codpago'])) {
            $this->recibo->codpago = $_POST['codpago'];
        }

        if ($this->recibo->save()) {
            $this->new_message('Datos guardados correctamente.');
        } else {
            $this->new_error_msg('Error al guardar los datos.');
        }
    }

    private function sacar_de_remesa()
    {
        $this->recibo->idremesa = NULL;

        if ($this->recibo->save()) {
            $this->new_message('Recibo desvinculado de la remesa correctamente.');
        } else {
            $this->new_error_msg('Error al desvincular de la remesa.');
        }
    }

    private function nuevo_pago()
    {
        $codsubcuenta = isset($_POST['codsubcuenta']) ? $_POST['codsubcuenta'] : false;
        $genasiento = isset($_POST['generarasiento']);

        if ($this->recibo_factura_tools->nuevo_pago_cli($this->recibo, $codsubcuenta, $_POST['tipo'], $_POST['fecha'], $genasiento)) {
            $this->new_message('Pago guardado correctamente.');
        } else {
            $this->new_error_msg('Error al guardar los pagos.');
        }
    }

    private function eliminar_pago($id)
    {
        foreach ($this->pago_model->all_from_recibo($this->recibo->idrecibo) as $pg) {
            if ($pg->idpagodevol == intval($id)) {
                if ($pg->delete()) {
                    $this->new_message($pg->tipo . ' eliminado correctamente');

                    $this->recibo->estado = 'Emitido';
                    $this->recibo->save();
                } else {
                    $this->new_error_msg('Error al eliminar el ' . $pg->tipo);
                }

                break;
            }
        }
    }

    public function url()
    {
        if ($this->recibo) {
            return $this->recibo->url();
        }

        return parent::url();
    }

    private function get_subcuentas()
    {
        $this->ejercicio = FALSE;
        $this->subcuenta_cli = FALSE;
        $this->subcuentas_pago = [];
        $this->ejercicio = isset($_POST['fecha']) ? $this->ejercicio_model->get_by_fecha($_POST['fecha']) : $this->ejercicio_model->get_by_fecha($this->today());
        if ($this->ejercicio) {
            $subcuenta = new subcuenta();
            $cli = new cliente();
            $this->cliente = $cli->get($this->recibo->codcliente);
            if ($this->cliente && $this->empresa->contintegrada) {
                $this->subcuenta_cli = $this->cliente->get_subcuenta($this->ejercicio->codejercicio);
            }

            /// añadimos la subcuenta de la cuenta bancaria
            $formap = $this->forma_pago->get($this->recibo->codpago);
            if ($formap && $formap->codcuenta) {
                $cuentab = $this->cuenta_banco->get($formap->codcuenta);
                if ($cuentab) {
                    $subc = $subcuenta->get_by_codigo($cuentab->codsubcuenta, $this->ejercicio->codejercicio);
                    if ($subc) {
                        $this->subcuentas_pago[] = $subc;
                    }
                }
            }

            /// añadimos todas las subcuentas de caja
            $sql = "SELECT * FROM co_subcuentas WHERE idcuenta IN "
                . "(SELECT idcuenta FROM co_cuentas WHERE codejercicio = "
                . $this->ejercicio->var2str($this->ejercicio->codejercicio) . " AND idcuentaesp = 'CAJA');";
            $data = $this->db->select($sql);
            if ($data) {
                foreach ($data as $d) {
                    $this->subcuentas_pago[] = new subcuenta($d);
                }
            }
        }
    }
}
