<?php
/**
 * @author Carlos García Gómez      neorazorx@gmail.com
 * @copyright 2015-2017, Carlos García Gómez. All Rights Reserved. 
 */
require_once 'plugins/facturacion_base/extras/fbase_controller.php';

/**
 * Description of tesoreria_controller
 *
 * @author carlos
 */
class tesoreria_controller extends fbase_controller
{

    protected $ejercicio_model;
    public $forma_pago;
    public $recibo_cliente_model;
    protected $recibo_factura_tools;
    public $recibo_proveedor_model;

    protected function private_core()
    {
        parent::private_core();
        $this->ejercicio_model = new ejercicio();
        $this->forma_pago = new forma_pago();
        $this->recibo_cliente_model = new recibo_cliente();
        $this->recibo_factura_tools = new recibo_factura();
        $this->recibo_proveedor_model = new recibo_proveedor();
    }

    protected function get_num_pendientes($table_name)
    {
        /// ahora obtenemos el número de recibos pendientes
        $sql = "SELECT COUNT(idrecibo) as num FROM " . $table_name . " WHERE estado = 'Emitido'"
            . " AND fechav >= " . $this->empresa->var2str(date('d-m-Y')) . ';';
        $data = $this->db->select($sql);
        if ($data) {
            return intval($data[0]['num']);
        }

        return 0;
    }

    protected function get_num_vencidos($table_name)
    {
        /// ahora obtenemos el número de recibos vencidos
        $sql = "SELECT COUNT(idrecibo) as num FROM " . $table_name . " WHERE estado = 'Devuelto' OR estado = 'Vencido';";
        $data = $this->db->select($sql);
        if ($data) {
            return intval($data[0]['num']);
        }

        return 0;
    }

    public function get_subcuentas_caja($fecha = '')
    {
        $subcuentas_caja = [];
        if ($fecha === '') {
            $fecha = $this->today();
        }

        $ejercicio = $this->ejercicio_model->get_by_fecha($fecha);
        if ($ejercicio) {
            /// añadimos todas las subcuentas de caja
            $sql = "SELECT * FROM co_subcuentas WHERE idcuenta IN "
                . "(SELECT idcuenta FROM co_cuentas WHERE codejercicio = "
                . $ejercicio->var2str($ejercicio->codejercicio) . " AND idcuentaesp = 'CAJA');";

            $data = $this->db->select($sql);
            if ($data) {
                foreach ($data as $d) {
                    $subcuentas_caja[] = new subcuenta($d);
                }
            }
        } else {
            $this->new_error_msg('No se encuentra un ejercicio abierto para la fecha ' . $fecha);
        }

        return $subcuentas_caja;
    }

    public function iframe_xid()
    {
        return "<div class='hidden'><iframe src='https://www.facturascripts.com/comm3/index.php?page=community_stats"
            . "&add=TRUE&version=" . $this->version() . "&xid=" . $this->empresa->xid . "&plugins=" . join(',', $GLOBALS['plugins']) . "'>"
            . "</iframe></div>";
    }

    public function orden_recibos()
    {
        return array(
            'fecha_desc' => array(
                'icono' => '<span class="glyphicon glyphicon-sort-by-attributes-alt" aria-hidden="true"></span>',
                'texto' => 'Fecha',
                'orden' => 'fecha DESC'
            ),
            'fecha_asc' => array(
                'icono' => '<span class="glyphicon glyphicon-sort-by-attributes" aria-hidden="true"></span>',
                'texto' => 'Fecha',
                'orden' => 'fecha ASC'
            ),
            'fechav_desc' => array(
                'icono' => '<span class="glyphicon glyphicon-sort-by-attributes-alt" aria-hidden="true"></span>',
                'texto' => 'Vencimiento',
                'orden' => 'fechav DESC'
            ),
            'fechav_asc' => array(
                'icono' => '<span class="glyphicon glyphicon-sort-by-attributes" aria-hidden="true"></span>',
                'texto' => 'Vencimiento',
                'orden' => 'fechav ASC'
            ),
            'codigo_desc' => array(
                'icono' => '<span class="glyphicon glyphicon-sort-by-attributes-alt" aria-hidden="true"></span>',
                'texto' => 'Código',
                'orden' => 'codigo DESC'
            ),
            'codigo_asc' => array(
                'icono' => '<span class="glyphicon glyphicon-sort-by-attributes" aria-hidden="true"></span>',
                'texto' => 'Código',
                'orden' => 'codigo ASC'
            ),
            'importe_desc' => array(
                'icono' => '<span class="glyphicon glyphicon-sort-by-attributes-alt" aria-hidden="true"></span>',
                'texto' => 'Importe',
                'orden' => 'importe DESC'
            )
        );
    }
}
