<?php
/**
 * @author Carlos García Gómez <neorazorx@gmail.com>
 * @copyright 2019, Carlos García Gómez. All Rights Reserved. 
 */
require_once 'plugins/facturacion_base/model/core/asiento_factura.php';

/**
 * Esta clase permite genera un asiento a partir de una factura.
 *
 * @author Carlos García Gómez <neorazorx@gmail.com>
 */
class asiento_factura extends FacturaScripts\model\asiento_factura
{

    /**
     * 
     * @param asiento   $asiento
     * @param string    $codpago
     * @param string    $fecha
     * @param subcuenta $subclipro
     * @param float     $importe0
     *
     * @return int
     */
    public function generar_asiento_pago(&$asiento, $codpago = false, $fecha = false, $subclipro = false, $importe0 = null)
    {
        /// si hay recibos, no generamos el asiento de pago
        $factura = $asiento->get_factura();
        if ($factura && $asiento->tipodocumento == 'Factura de cliente') {
            $recibo_model = new recibo_cliente();
            foreach ($recibo_model->all_from_factura($factura->idfactura) as $rec) {
                return null;
            }
        } elseif ($factura && $asiento->tipodocumento == 'Factura de proveedor') {
            $recibo_model = new recibo_proveedor();
            foreach ($recibo_model->all_from_factura($factura->idfactura) as $rec) {
                return null;
            }
        }

        return parent::generar_asiento_pago($asiento, $codpago, $fecha, $subclipro, $importe0);
    }
}
