<?php
/**
 * @author Carlos García Gómez <neorazorx@gmail.com>
 * @copyright 2015-2019, Carlos García Gómez. All Rights Reserved. 
 */

/**
 * Description of forma_pago_plazo
 * Esta clase sirve para estableces plazos de pago de facturas, y dividir los
 * recibos de las facturas en tantos como plazos haya asociados a su forma de
 * pago.
 *
 * @author Carlos García Gómez
 */
class forma_pago_plazo extends fs_model
{

    /**
     * % del importe de la factura aplazado.
     * @var float
     */
    public $aplazado;

    /**
     * Código de la forma de pago asociada. Obligatorio.
     * @var string
     */
    public $codpago;

    /**
     * Nº de días desde la fecha de la factura.
     * @var int
     */
    public $dias;

    /**
     * Clave primaria.
     * @var int
     */
    public $id;

    /**
     *
     * @var int
     */
    public $meses;

    public function __construct($data = FALSE)
    {
        parent::__construct('plazos');
        if ($data) {
            $this->aplazado = floatval($data['aplazado']);
            $this->codpago = $data['codpago'];
            $this->dias = intval($data['dias']);
            $this->id = $this->intval($data['id']);
            $this->meses = intval($data['meses']);
        } else {
            $this->aplazado = 0.0;
            $this->codpago = NULL;
            $this->dias = 0;
            $this->id = NULL;
            $this->meses = 0;
        }
    }

    public function vencimiento()
    {
        $str = '+' . $this->dias . ' days';
        return ($this->meses > 0) ? '+' . $this->meses . ' months ' . $str : $str;
    }

    protected function install()
    {
        return '';
    }

    public function get($id)
    {
        $data = $this->db->select("SELECT * FROM plazos WHERE id = " . $this->var2str($id) . ";");
        if ($data) {
            return new forma_pago_plazo($data[0]);
        }

        return FALSE;
    }

    public function exists()
    {
        if (is_null($this->id)) {
            return FALSE;
        }

        return $this->db->select("SELECT * FROM plazos WHERE id = " . $this->var2str($this->id) . ";");
    }

    public function save()
    {
        if ($this->exists()) {
            $sql = "UPDATE plazos SET codpago = " . $this->var2str($this->codpago) .
                ", aplazado = " . $this->var2str($this->aplazado) .
                ", dias = " . $this->var2str($this->dias) .
                ", meses = " . $this->var2str($this->meses) .
                "  WHERE id = " . $this->var2str($this->id) . ";";

            return $this->db->exec($sql);
        }

        $sql = "INSERT INTO plazos (codpago,aplazado,dias,meses) VALUES (" .
            $this->var2str($this->codpago) . "," .
            $this->var2str($this->aplazado) . "," .
            $this->var2str($this->dias) . "," .
            $this->var2str($this->meses) . ");";

        if ($this->db->exec($sql)) {
            $this->id = $this->db->lastval();
            return TRUE;
        }

        return FALSE;
    }

    public function delete()
    {
        return $this->db->exec("DELETE FROM plazos WHERE id = " . $this->var2str($this->id) . ";");
    }

    /**
     * Devuelve los plazos de una forma de pago.
     * @param type $codpago
     */
    public function all_from($codpago)
    {
        $plist = [];

        $sql = "SELECT * FROM plazos WHERE codpago = " . $this->var2str($codpago) . " ORDER BY dias ASC;";
        $data = $this->db->select($sql);
        if ($data) {
            foreach ($data as $d) {
                $plist[] = new forma_pago_plazo($d);
            }
        }

        return $plist;
    }
}
