<?php if(!class_exists('raintpl')){exit;}?><div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-header" style="margin-bottom: 0px;">
                <h1>
                    <i class="fa fa-server" aria-hidden="true"></i>
                    Información del sistema
                    <span class="btn-group">
                        <a class="btn btn-xs btn-default" href="<?php echo $fsc->url();?>" title="Recargar la página">
                            <span class="glyphicon glyphicon-refresh"></span>
                        </a>
                        <?php if( $fsc->page->is_default() ){ ?>

                        <a class="btn btn-xs btn-default active" href="<?php echo $fsc->url();?>&amp;default_page=FALSE" title="Marcada como página de inicio (pulsa de nuevo para desmarcar)">
                            <i class="fa fa-bookmark" aria-hidden="true"></i>
                        </a>
                        <?php }else{ ?>

                        <a class="btn btn-xs btn-default" href="<?php echo $fsc->url();?>&amp;default_page=TRUE" title="Marcar como página de inicio">
                            <i class="fa fa-bookmark-o" aria-hidden="true"></i>
                        </a>
                        <?php } ?>

                    </span>
                </h1>
                <p class='help-block'>
                    Aquí tienes información básica sobre esta instalación de FacturaScripts,
                    base de datos, listado de tablas y el historial de errores con múltiples
                    filtros, para facilitarte el trabajo a la hora de encontrar un fallo.
                </p>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th class="text-left">FacturaScripts</th>
                    <th class="text-center">PHP</th>
                    <th class="text-center">Base de datos</th>
                    <th class="text-center">Motor de base de datos</th>
                    <th class="text-right">Caché</th>
                </tr>
            </thead>
            <tr>
                <td><a href="<?php  echo FS_COMMUNITY_URL;?>/index.php?page=community_changelog&version=<?php echo $fsc->version();?>" target="_blank"><?php echo $fsc->version();?></a></td>
                <td class="text-center"><?php echo $fsc->php_version();?></td>
                <td class="text-center"><?php echo $fsc->fs_db_name();?></td>
                <td class="text-center"><?php echo $fsc->fs_db_version();?></td>
                <td class="text-right"><?php echo $fsc->cache_version();?></td>
            </tr>
        </table>
    </div>
    <div class="row">
        <div class="col-xs-8">
            <div class="btn-group">
                <?php $loop_var1=$fsc->extensions; $counter1=-1; if($loop_var1) foreach( $loop_var1 as $key1 => $value1 ){ $counter1++; ?>

                <?php if( $value1->type=='button' ){ ?>

                <a href="index.php?page=<?php echo $value1->from;?><?php echo $value1->params;?>" class="btn btn-xs btn-default"><?php echo $value1->text;?></a>
                <?php } ?>

                <?php } ?>

            </div>
        </div>
        <div class="col-xs-4 text-right">
            <?php if( $fsc->allow_delete ){ ?>

            <a class="btn btn-xs btn-danger" href="<?php echo $fsc->url();?>&clean_cache=TRUE">
                <i class="fa fa-trash" aria-hidden="true"></i>
                <span class="hidden-xs">&nbsp;Limpiar la cache</span>
            </a>
            <?php } ?>

        </div>
    </div>
    <?php if( $fsc->get_locks() ){ ?>

    <div class="row">
        <div class="col-sm-12">
            <br/>
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <h3 class="panel-title">Bloqueos en la base de datos</h3>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th class="text-left">Base de datos</th>
                                <th class="text-left">relname</th>
                                <th class="text-left">relation</th>
                                <th class="text-left">transaction ID</th>
                                <th class="text-left">PID</th>
                                <th class="text-left">modo</th>
                                <th class="text-left">granted</th>
                            </tr>
                        </thead>
                        <?php $loop_var1=$fsc->get_locks(); $counter1=-1; if($loop_var1) foreach( $loop_var1 as $key1 => $value1 ){ $counter1++; ?>

                        <tr>
                            <td><?php echo $value1["database"];?></td>
                            <td><?php echo $value1["relname"];?></td>
                            <td><?php echo $value1["relation"];?></td>
                            <td><?php echo $value1["transactionid"];?></td>
                            <td><?php echo $value1["pid"];?></td>
                            <td><?php echo $value1["mode"];?></td>
                            <td><?php echo $value1["granted"];?></td>
                        </tr>
                        <?php }else{ ?>

                        <tr class="warning">
                            <td colspan="7">Ningún bloqueo detectado.</td>
                        </tr>
                        <?php } ?>

                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

</div>